function model = draw_cavity(geom, model, workplane)

    format long;
    
    % Rectangular area in the unit cell where the geometry has to be specified
    rect1_x = [geom.mech.amech/4 geom.mech.amech/4 geom.mech.amech*3/4 geom.mech.amech*3/4 geom.mech.amech/4];
    rect1_y = [0 geom.mech.amech*sqrt(3)/2 geom.mech.amech*sqrt(3)/2 0 0];

    rect2_x = [geom.mech.amech*3/4 geom.mech.amech*3/4 geom.mech.amech geom.mech.amech geom.mech.amech*3/4];
    rect2_y = [-geom.mech.amech*sqrt(3)/2 geom.mech.amech*sqrt(3)/2 geom.mech.amech*sqrt(3)/2 -geom.mech.amech*sqrt(3)/2 -geom.mech.amech*sqrt(3)/2];

    % plot(rect1_x, rect1_y, 'color', 'red', 'LineWidth', 0.5)
    % plot(rect2_x, rect2_y, 'color', 'blue', 'LineWidth', 0.5)

    % Hexagon of small unit cell
    hex_x1 = [0 0 geom.mech.amech/2 geom.mech.amech geom.mech.amech geom.mech.amech/2 0];
    hex_y1 = [-geom.mech.amech/(2*sqrt(3)) geom.mech.amech/(2*sqrt(3)) geom.mech.amech/sqrt(3) geom.mech.amech/(2*sqrt(3)) -geom.mech.amech/(2*sqrt(3)) -geom.mech.amech/sqrt(3) -geom.mech.amech/(2*sqrt(3))];

    % plot(hex_x1, hex_y1, 'color', 'red', 'LineWidth', 0.5)

    % Draw snowflakes
    % angle = -60;
    x_cen = geom.mech.amech/2;
    y_cen = 0;
    [snowflake_cen_x, snowflake_cen_y] = coordinates_round_snowflake_fine(x_cen, y_cen, geom.mech.r, geom.mech.w, geom.mech.rad_curv, geom.mech.rad_curv2, geom.mech.resolution*4);

    snowflake_x4 = snowflake_cen_x + geom.mech.amech/2;
    snowflake_y4 = snowflake_cen_y + geom.mech.amech*sqrt(3)/2;

    % Coordinates of triangle where the hole sizes are scaled in order to create topological bandgap
    x_cen = geom.mech.amech;
    y_cen = geom.mech.amech/(2*sqrt(3));
    geom.mech.tri_defect_x = [x_cen-geom.mech.gap_defect_length/sqrt(3) x_cen x_cen+geom.mech.gap_defect_length/sqrt(3)];
    geom.mech.tri_defect_y = [y_cen-geom.mech.gap_defect_length/3 y_cen+geom.mech.gap_defect_length*2/3 y_cen-geom.mech.gap_defect_length/3];

    % plot(geom.mech.tri_defect_x, geom.mech.tri_defect_y, 'color', 'red', 'LineWidth', 0.5)

    % Position of optical cavity
    x_cen = geom.mech.amech/2;
    y_cen = geom.mech.amech/sqrt(3) + geom.opt.cavity_shift*geom.opt.a1/2;
    temp_x = [x_cen-geom.opt.defect_width/2 x_cen-geom.opt.defect_width/2 x_cen+geom.opt.defect_width/2 x_cen+geom.opt.defect_width/2];
    temp_y = [y_cen-geom.opt.defect_length/2 y_cen+geom.opt.defect_length/2 y_cen+geom.opt.defect_length/2 y_cen-geom.opt.defect_length/2];
    [geom.opt.defect_x, geom.opt.defect_y] = rotate(temp_x, temp_y, x_cen, y_cen, geom.opt.cavity_rot);

    % plot(geom.opt.defect_x, geom.opt.defect_y, 'color', 'red', 'LineWidth', 0.5)

    delta2 = [geom.opt.a1*ones(1,geom.opt.nv-5), ...
        (geom.opt.a1+geom.opt.a2)/2, ... %1
        geom.opt.a2, ... %2
        (geom.opt.a2+geom.opt.a3)/2, ... %3
        geom.opt.a3, ... %4
        (geom.opt.a3+geom.opt.a4)/2, ... %5
        geom.opt.a4, ... %6
        (geom.opt.a3+geom.opt.a4)/2, ... %7
        geom.opt.a3, ... %8
        (geom.opt.a2+geom.opt.a3)/2, ... %9
        geom.opt.a2, ... %10
        (geom.opt.a1+geom.opt.a2)/2, ... %11
        geom.opt.a1*ones(1,geom.opt.nv-5)];

    delta1 = [geom.opt.a1*ones(1,geom.opt.nv-6), ...
        (geom.opt.a1+(geom.opt.a1+geom.opt.a2)/2)/2, ... %1
        (geom.opt.a2+(geom.opt.a1+geom.opt.a2)/2)/2, ... %2
        (geom.opt.a2+(geom.opt.a2+geom.opt.a3)/2)/2, ... %3
        (geom.opt.a3+(geom.opt.a2+geom.opt.a3)/2)/2, ... %4
        (geom.opt.a3+(geom.opt.a3+geom.opt.a4)/2)/2, ... %5
        (geom.opt.a4+(geom.opt.a3+geom.opt.a4)/2)/2, ... %6
        (geom.opt.a4+(geom.opt.a3+geom.opt.a4)/2)/2, ... %7
        (geom.opt.a3+(geom.opt.a3+geom.opt.a4)/2)/2, ... %8
        (geom.opt.a3+(geom.opt.a2+geom.opt.a3)/2)/2, ... %9
        (geom.opt.a2+(geom.opt.a2+geom.opt.a3)/2)/2, ... %10
        (geom.opt.a2+(geom.opt.a1+geom.opt.a2)/2)/2, ... %11
        (geom.opt.a1+(geom.opt.a1+geom.opt.a2)/2)/2, ... %12
        geom.opt.a1*ones(1,geom.opt.nv-6)];
    x = zeros(2*geom.opt.nv+1, 2*geom.opt.nh+1);
    y = zeros(2*geom.opt.nv+1, 2*geom.opt.nh+1);
    rad = zeros(2*geom.opt.nv+1, 2*geom.opt.nh+1);
    radb = zeros(2*geom.opt.nv+1, 2*geom.opt.nh+1);

    for j = -geom.opt.nh:geom.opt.nh
        if j==-geom.opt.nh
            if rem(geom.opt.nv,2) == 0
                x(:,j+geom.opt.nh+1) = -geom.opt.nh*geom.opt.a1*sqrt(3)/2 - geom.opt.W/2;
            else
                x(:,j+geom.opt.nh+1) = -(geom.opt.nh+1)*geom.opt.a1*sqrt(3)/2 - geom.opt.W/2;
            end
        else
            if j==0 || j==1
                x(:,j+geom.opt.nh+1) = x(:,j+geom.opt.nh) + (geom.opt.a1*sqrt(3) + geom.opt.W)/2;
            else
                x(:,j+geom.opt.nh+1) = x(:,j+geom.opt.nh) + geom.opt.a1*sqrt(3)/2;
            end
        end

        for i=-geom.opt.nv:geom.opt.nv
            rad(i+geom.opt.nv+1,j+geom.opt.nh+1) = geom.opt.r;

            if i==-geom.opt.nv
                if rem(j,2)==0
                    y(i+geom.opt.nv+1,j+geom.opt.nh+1) = -sum(delta1(1:geom.opt.nv));
                else
                    y(i+geom.opt.nv+1,j+geom.opt.nh+1) = -sum(delta2(1:geom.opt.nv))-geom.opt.a3/2;
                end
            else
                if rem(j,2)==0
                    y(i+geom.opt.nv+1,j+geom.opt.nh+1) = y(i+geom.opt.nv,j+geom.opt.nh+1)+delta1(i+geom.opt.nv);
                else
                    y(i+geom.opt.nv+1,j+geom.opt.nh+1) = y(i+geom.opt.nv,j+geom.opt.nh+1)+delta2(i+geom.opt.nv);
                end
            end
        end
    end

    temp_x = x+x_cen;
    temp_y = y+y_cen;
    [x, y] = rotate(temp_x, temp_y, x_cen, y_cen, geom.opt.cavity_rot);

    % Constructing cavity holes in region 1 of geometry schematic
    count_a = 1; count_b = 1; count_c = 1; inp_c = [];
    
    for j = -geom.opt.nh:geom.opt.nh
        for i = -geom.opt.nv:geom.opt.nv
            x1 = x(i+geom.opt.nv+1,j+geom.opt.nh+1);
            y1 = y(i+geom.opt.nv+1,j+geom.opt.nh+1);

            r1 = rad(i+geom.opt.nv+1,j+geom.opt.nh+1);
            rh = geom.opt.h;
            rb = geom.opt.b;

            if inpolygon(x1, y1, geom.opt.defect_x, geom.opt.defect_y) == 0
                phi = linspace(0,2*pi,19);
                xx = x1 + r1*cos(phi);
                yy = y1 + r1*sin(phi);
            else
                y1 = y(i+geom.opt.nv+1,j+1+geom.opt.nh+1);
                phi = linspace(0,2*pi,19);
                xx = x1 + rb*cos(phi);
                yy = y1 + rh*sin(phi);
            end

            for k=1:length(xx)-1
                check(k)=abs(p_poly_dist1(xx(k),yy(k),snowflake_cen_x,snowflake_cen_y));
            end

            in_scale_tri = inpolygon(xx(1:end-1), yy(1:end-1), geom.mech.tri_defect_x, geom.mech.tri_defect_y);
            in_scale_tri2 = inpolygon(xx(1:end-1), yy(1:end-1), geom.mech.tri_defect_x-geom.mech.amech, geom.mech.tri_defect_y);
            in_defect = inpolygon(xx(1:end-1), yy(1:end-1), geom.opt.defect_x, geom.opt.defect_y);
            in_rect1 = inpolygon(xx(1:end-1), yy(1:end-1), rect1_x, rect1_y);
            in_uc = inpolygon(xx(1:end-1), yy(1:end-1), hex_x1, hex_y1);
            in = inpolygon(xx(1:end-1), yy(1:end-1), snowflake_cen_x, snowflake_cen_y);

            dist1 = x1 - geom.mech.amech/4;
            dist2 = geom.mech.amech*3/4 - x1;
            
            tag = strcat('c','x',num2str(i),'y',num2str(j));

            if min(check)>geom.bridge_width && sum(in_uc)==length(xx)-1 && sum(in_rect1)==length(xx)-1 && sum(in)==0 && sum(in_defect)==0 && dist1>geom.opt.a1*sqrt(3)/2 && dist2>geom.opt.a1*sqrt(3)/2
                if sum(in_scale_tri) == length(xx)-1 || sum(in_scale_tri2) == length(xx)-1
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));
                else
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1,'%10.9e'));
                end
                
                inp_a(count_a) = {tag};
                count_a = count_a + 1;

            elseif min(check)>geom.bridge_width && sum(in_uc)>0 && sum(in_rect1)==length(xx)-1 && sum(in)==0 && sum(in_defect)==0 && dist1>geom.opt.a1*sqrt(3)/2 && dist2>geom.opt.a1*sqrt(3)/2
                if max(xx)<geom.mech.amech/2
                    if sum(in_scale_tri) == length(xx)-1 || sum(in_scale_tri2) == length(xx)-1
                        cir = workplane.geom.create(tag, 'Circle');
                        cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                        cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));
                    else
                        cir = workplane.geom.create(tag, 'Circle');
                        cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                        cir.set('r', num2str(r1,'%10.9e'));
                    end
                    
                    inp_a(count_a) = {tag};
                    count_a = count_a + 1;
                    
                elseif min(xx)>geom.mech.amech/2
                    x1 = x1 - geom.mech.amech/2;
                    y1 = y1 - geom.mech.amech*sqrt(3)/2;

                    if sum(in_scale_tri) == length(xx)-1 || sum(in_scale_tri2) == length(xx)-1
                        cir = workplane.geom.create(tag, 'Circle');
                        cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                        cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));
                    else
                        cir = workplane.geom.create(tag, 'Circle');
                        cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                        cir.set('r', num2str(r1,'%10.9e'));
                    end
                    
                    inp_b(count_b) = {tag};
                    count_b = count_b + 1;
                end

            elseif min(check)>geom.bridge_width && sum(in_uc)>0 && sum(in_rect1)==length(xx)-1 && sum(in)==0 && sum(in_defect)~=0 && geom.opt.h ~=0 && geom.opt.b ~=0 && dist1>geom.opt.a1*sqrt(3)/2 && dist2>geom.opt.a1*sqrt(3)/2
                if sum(in_scale_tri) == length(xx)-1 || sum(in_scale_tri2) == length(xx)-1
                    ell = workplane.geom.create(tag, 'Ellipse');
                    ell.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    ell.set('semiaxes', {num2str(rb*geom.opt.scale_top_gap,'%10.9e') num2str(rh*geom.opt.scale_top_gap,'%10.9e')});
                else
                    ell = workplane.geom.create(tag, 'Ellipse');
                    ell.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    ell.set('semiaxes', {num2str(rb,'%10.9e') num2str(rh,'%10.9e')});
                end
                
                inp_a(count_a) = {tag};
                count_a = count_a + 1;

            elseif min(check)>geom.bridge_width && sum(in_uc)>0 && sum(in_rect1)==length(xx)-1 && sum(in)==0 && sum(in_defect)==0 && dist2<geom.opt.a1*sqrt(3)/2
                x1 = x1 + (dist2 - geom.opt.a1*sqrt(3)/2)/2;

                if sum(in_uc)==length(xx)-1
                    if sum(in_scale_tri) == length(xx)-1 || sum(in_scale_tri2) == length(xx)-1
                        cir = workplane.geom.create(tag, 'Circle');
                        cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                        cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));
                    else
                        cir = workplane.geom.create(tag, 'Circle');
                        cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                        cir.set('r', num2str(r1,'%10.9e'));
                    end
                    
                    inp_a(count_a) = {tag};
                    count_a = count_a + 1;
                
                else
                    x1 = x1 - geom.mech.amech/2;
                    y1 = y1 - geom.mech.amech*sqrt(3)/2;

                    if sum(in_scale_tri) == length(xx)-1 || sum(in_scale_tri2) == length(xx)-1
                        cir = workplane.geom.create(tag, 'Circle');
                        cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                        cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));
                    else
                        cir = workplane.geom.create(tag, 'Circle');
                        cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                        cir.set('r', num2str(r1,'%10.9e'));
                    end
                    
                    inp_b(count_b) = {tag};
                    count_b = count_b + 1;
                end

            elseif min(check)>geom.bridge_width && sum(in_uc)>0 && sum(in_rect1)==length(xx)-1 && sum(in)==0 && sum(in_defect)==0 && dist1<geom.opt.a1*sqrt(3)/2
                x1 = x1 + (geom.opt.a1*sqrt(3)/2 - dist1)/2;

                if sum(in_scale_tri) == length(xx)-1 || sum(in_scale_tri2) == length(xx)-1
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));
                else
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1,'%10.9e'));
                end
                
                inp_a(count_a) = {tag};
                count_a = count_a + 1;
            end
        end
    end
    
    % Constructing cavity holes in region 2 of geometry schematic
    geom.opt.defect_x = geom.opt.defect_x + geom.mech.amech/2;
    geom.opt.defect_y = geom.opt.defect_y - geom.mech.amech*sqrt(3)/2;

    for j = -geom.opt.nh:geom.opt.nh
        for i = -geom.opt.nv:geom.opt.nv
            x1 = x(i+geom.opt.nv+1,j+geom.opt.nh+1) + geom.mech.amech/2;
            y1 = y(i+geom.opt.nv+1,j+geom.opt.nh+1) - geom.mech.amech*sqrt(3)/2;

            r1 = rad(i+geom.opt.nv+1,j+geom.opt.nh+1);
            rh = geom.opt.h;
            rb = geom.opt.b;

            % Note that here y of the center holes is not exactly same as next
            % row because of cavity defect
            if inpolygon(x1, y1, geom.opt.defect_x, geom.opt.defect_y) == 0
                phi = linspace(0,2*pi,19);
                xx = x1 + r1*cos(phi);
                yy = y1 + r1*sin(phi);
            else
                y1 = y(i+geom.opt.nv+1,j+1+geom.opt.nh+1) - geom.mech.amech*sqrt(3)/2;
                phi = linspace(0,2*pi,19);
                xx = x1 + rb*cos(phi);
                yy = y1 + rh*sin(phi);
            end

            for k=1:length(xx)-1
                check(k)=abs(p_poly_dist1(xx(k),yy(k),snowflake_cen_x,snowflake_cen_y));
                check1(k)=abs(p_poly_dist1(xx(k),yy(k),snowflake_x4,snowflake_y4));
            end

            in_scale_tri = inpolygon(xx(1:end-1), yy(1:end-1), geom.mech.tri_defect_x, geom.mech.tri_defect_y);
            in_defect = inpolygon(xx(1:end-1), yy(1:end-1), geom.opt.defect_x, geom.opt.defect_y);
            in_rect2 = inpolygon(xx(1:end-1), yy(1:end-1), rect2_x, rect2_y);
            in_uc = inpolygon(xx(1:end-1), yy(1:end-1), hex_x1, hex_y1);
            in = inpolygon(xx(1:end-1), yy(1:end-1), snowflake_cen_x, snowflake_cen_y);
            in1 = inpolygon(xx(1:end-1), yy(1:end-1), snowflake_x4, snowflake_y4);

            dist = x1 - geom.mech.amech*3/4;

            if min(check)>geom.bridge_width && sum(in_uc)==length(xx)-1 && sum(in_rect2)==length(xx)-1 && sum(in)==0 && sum(in_defect)==0 && dist>geom.opt.a1*sqrt(3)/2
                if sum(in_scale_tri) == length(xx)-1
                    tag = strcat('c2','x',num2str(i),'y',num2str(j));
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                    
                    x1 = geom.mech.amech - x1;
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                else
                    tag = strcat('c2','x',num2str(i),'y',num2str(j));
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1,'%10.9e'));
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                    
                    x1 = geom.mech.amech - x1;
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1,'%10.9e'));
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                end

            elseif min(check)>geom.bridge_width && sum(in_rect2)>0 && sum(in)==0 && sum(in_uc)>0 && sum(in_defect)~=0 && geom.opt.h~=0 && geom.opt.b~=0 && dist>geom.opt.a1*sqrt(3)/2
                if sum(in_scale_tri) == length(xx)-1                
                    tag = strcat('c2','x',num2str(i),'y',num2str(j));
                    ell = workplane.geom.create(tag, 'Ellipse');
                    ell.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    ell.set('semiaxes', {num2str(rb*geom.opt.scale_top_gap,'%10.9e') num2str(rh*geom.opt.scale_top_gap,'%10.9e')});
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                    
                    x1 = geom.mech.amech - x1;
                    tag = strcat('c2_mir','x',num2str(i),'y',num2str(j));
                    ell = workplane.geom.create(tag, 'Ellipse');
                    ell.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    ell.set('semiaxes', {num2str(rb*geom.opt.scale_top_gap,'%10.9e') num2str(rh*geom.opt.scale_top_gap,'%10.9e')});
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                else
                    tag = strcat('c2','x',num2str(i),'y',num2str(j));
                    ell = workplane.geom.create(tag, 'Ellipse');
                    ell.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    ell.set('semiaxes', {num2str(rb,'%10.9e') num2str(rh,'%10.9e')});
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                    
                    x1 = geom.mech.amech - x1;
                    tag = strcat('c2_mir','x',num2str(i),'y',num2str(j));
                    ell = workplane.geom.create(tag, 'Ellipse');
                    ell.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    ell.set('semiaxes', {num2str(rb,'%10.9e') num2str(rh,'%10.9e')});
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                end

            elseif min(check)>geom.bridge_width && min(xx)<geom.mech.amech*3/4 && sum(in_uc)>0 && max(xx)>geom.mech.amech*3/4 && sum(in_rect2)>0 && sum(in)==0 && sum(in_defect)==0
                x1 = geom.mech.amech*3/4;
                if sum(in_uc)~=length(xx)-1
                    y1 = geom.mech.amech/sqrt(3) - abs((x1 - geom.mech.amech/2))/sqrt(3);
                end 

                if sum(in_scale_tri) == length(xx)-1
                    if sum(in_uc)~=length(xx)-1
                        tag = strcat('c2','x',num2str(i),'y',num2str(j));
                        cir = workplane.geom.create(tag, 'Circle');
                        cir.set('pos', {num2str(x1 - geom.mech.amech/2,'%10.9e') num2str(y1 - geom.mech.amech*sqrt(3)/2,'%10.9e')});
                        cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));

                        [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1 - geom.mech.amech*sqrt(3)/2, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                        
                        x1 = geom.mech.amech - x1;
                        tag = strcat('c2_mir','x',num2str(i),'y',num2str(j));
                        cir = workplane.geom.create(tag, 'Circle');
                        cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                        cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));

                        [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                    else
                        tag = strcat('c2','x',num2str(i),'y',num2str(j));
                        cir = workplane.geom.create(tag, 'Circle');
                        cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                        cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));

                        [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                        
                        x1 = geom.mech.amech - x1;
                        tag = strcat('c2_mir','x',num2str(i),'y',num2str(j));
                        cir = workplane.geom.create(tag, 'Circle');
                        cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                        cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));

                        [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                    end
                else
                    if sum(in_uc)~=length(xx)-1
                        tag = strcat('c2','x',num2str(i),'y',num2str(j));
                        cir = workplane.geom.create(tag, 'Circle');
                        cir.set('pos', {num2str(x1 - geom.mech.amech/2,'%10.9e') num2str(y1 - geom.mech.amech*sqrt(3)/2,'%10.9e')});
                        cir.set('r', num2str(r1,'%10.9e'));

                        [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1 - geom.mech.amech*sqrt(3)/2, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                        
                        x1 = geom.mech.amech - x1;
                        tag = strcat('c2_mir','x',num2str(i),'y',num2str(j));
                        cir = workplane.geom.create(tag, 'Circle');
                        cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                        cir.set('r', num2str(r1,'%10.9e'));

                        [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                    else
                        tag = strcat('c2','x',num2str(i),'y',num2str(j));
                        cir = workplane.geom.create(tag, 'Circle');
                        cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                        cir.set('r', num2str(r1,'%10.9e'));

                        [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                        
                        x1 = geom.mech.amech - x1;
                        tag = strcat('c2_mir','x',num2str(i),'y',num2str(j));
                        cir = workplane.geom.create(tag, 'Circle');
                        cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                        cir.set('r', num2str(r1,'%10.9e'));

                        [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                    end
                end

            elseif min(check)>geom.bridge_width && sum(in_uc)==length(xx)-1 && sum(in_rect2)==length(xx)-1 && sum(in)==0 && sum(in_defect)==0 && dist<geom.opt.a1*sqrt(3)/2
                x1 = x1 + (geom.opt.a1*sqrt(3)/2 - dist)/2;

                if sum(in_scale_tri) == length(xx)-1
                    tag = strcat('c2','x',num2str(i),'y',num2str(j));
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                    
                    x1 = geom.mech.amech - x1;
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                else
                    tag = strcat('c2','x',num2str(i),'y',num2str(j));
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1,'%10.9e'));
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                    
                    x1 = geom.mech.amech - x1;
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1,'%10.9e'));
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                end

            elseif min(check)>geom.bridge_width && sum(in_uc)>0 && sum(in_rect2)>0 && sum(in)==0 && sum(in1)==0 && min(xx)>geom.mech.amech*3/4 && min(yy)>0
                if sum(in_scale_tri) == length(xx)-1
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(geom.mech.amech - x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                else                    
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(geom.mech.amech - x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1,'%10.9e'));
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                end

                x1 = x1 - geom.mech.amech/2;
                y1 = y1 - geom.mech.amech*sqrt(3)/2;

                if sum(in_scale_tri) == length(xx)-1
                    tag = strcat('c2','x',num2str(i),'y',num2str(j));
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                else
                    tag = strcat('c2','x',num2str(i),'y',num2str(j));
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1,'%10.9e'));
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                end

            elseif min(check1)>geom.bridge_width && sum(in_uc)==0 && sum(in_rect2)>0 && sum(in)==0 && sum(in1)==0 && min(xx)>geom.mech.amech*3/4 && min(yy)>0 && sum(in_defect)==0
                x1 = x1 - geom.mech.amech/2;
                y1 = y1 - geom.mech.amech*sqrt(3)/2;

                if sum(in_scale_tri) == length(xx)-1
                    tag = strcat('c2_','x',num2str(i),'y',num2str(j));
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                    
                    x1 = geom.mech.amech - x1;
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1*geom.opt.scale_top_gap,'%10.9e'));
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                else
                    tag = strcat('c2_','x',num2str(i),'y',num2str(j));
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1,'%10.9e'));
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                    
                    x1 = geom.mech.amech - x1;
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    cir = workplane.geom.create(tag, 'Circle');
                    cir.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    cir.set('r', num2str(r1,'%10.9e'));
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                end
                
            elseif min(check1)>geom.bridge_width && sum(in_uc)==0 && sum(in_rect2)>0 && sum(in)==0 && sum(in1)==0 && min(xx)>geom.mech.amech*3/4 && min(yy)>0 && sum(in_defect)~=0
                x1 = x1 - geom.mech.amech/2;
                y1 = y1 - geom.mech.amech*sqrt(3)/2;

                if sum(in_scale_tri) == length(xx)-1
                    tag = strcat('c2_','x',num2str(i),'y',num2str(j));
                    ell = workplane.geom.create(tag, 'Ellipse');
                    ell.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    ell.set('semiaxes', {num2str(rb*geom.opt.scale_top_gap,'%10.9e') num2str(rh*geom.opt.scale_top_gap,'%10.9e')});
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                    
                    x1 = geom.mech.amech - x1;
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    ell = workplane.geom.create(tag, 'Ellipse');
                    ell.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    ell.set('semiaxes', {num2str(rb*geom.opt.scale_top_gap,'%10.9e') num2str(rh*geom.opt.scale_top_gap,'%10.9e')});
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                else
                    tag = strcat('c2_','x',num2str(i),'y',num2str(j));
                    ell = workplane.geom.create(tag, 'Ellipse');
                    ell.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    ell.set('semiaxes', {num2str(rb,'%10.9e') num2str(rh,'%10.9e')});
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                    
                    x1 = geom.mech.amech - x1;
                    tag = strcat('c2_mir_','x',num2str(i),'y',num2str(j));
                    ell = workplane.geom.create(tag, 'Ellipse');
                    ell.set('pos', {num2str(x1,'%10.9e') num2str(y1,'%10.9e')});
                    ell.set('semiaxes', {num2str(rb,'%10.9e') num2str(rh,'%10.9e')});
                    
                    [inp_a, inp_b, inp_c, count_a, count_b, count_c] = decide_cavity_region(geom, y1, inp_a, inp_b, inp_c, count_a, count_b, count_c, tag);
                end
            end
        end
    end
    
    uni = workplane.geom.create('uni_a', 'Union');
    uni.selection('input').set(inp_a);
    
    uni = workplane.geom.create('uni_b', 'Union');
    uni.selection('input').set(inp_b);
    
    uni = workplane.geom.create('uni_c', 'Union');
    uni.selection('input').set(inp_c);
    
    copy = workplane.geom.create('cp1_a', 'Copy');
    copy.selection('input').set({'uni_a'});
    copy.set('displx', num2str(geom.mech.amech/2,'%10.9e'));
    copy.set('disply', num2str(-geom.mech.amech*sqrt(3)/2,'%10.9e'));
    
    copy = workplane.geom.create('cp2_a', 'Copy');
    copy.selection('input').set({'uni_a'});
    copy.set('displx', num2str(-geom.mech.amech/2,'%10.9e'));
    copy.set('disply', num2str(-geom.mech.amech*sqrt(3)/2,'%10.9e'));
    
    copy = workplane.geom.create('cp1_b', 'Copy');
    copy.selection('input').set({'uni_b'});
    copy.set('displx', num2str(geom.mech.amech/2,'%10.9e'));
    copy.set('disply', num2str(-geom.mech.amech*sqrt(3)/2,'%10.9e'));
    
    copy = workplane.geom.create('cp2_b', 'Copy');
    copy.selection('input').set({'uni_b'});
    copy.set('displx', num2str(-geom.mech.amech/2,'%10.9e'));
    copy.set('disply', num2str(-geom.mech.amech*sqrt(3)/2,'%10.9e'));
    
    copy = workplane.geom.create('cp1_c', 'Copy');
    copy.selection('input').set({'uni_c'});
    copy.set('displx', num2str(geom.mech.amech/2,'%10.9e'));
    copy.set('disply', num2str(-geom.mech.amech*sqrt(3)/2,'%10.9e'));
    
    copy = workplane.geom.create('cp2_c', 'Copy');
    copy.selection('input').set({'uni_c'});
    copy.set('displx', num2str(-geom.mech.amech/2,'%10.9e'));
    copy.set('disply', num2str(-geom.mech.amech*sqrt(3)/2,'%10.9e'));
    
    if rem(geom.stack.num_domy, 2)==0
        copy = workplane.geom.create('cp_wall_c', 'Copy');
        copy.selection('input').set({'uni_c'});
        copy.set('displx', '0');
        copy.set('disply', num2str(-geom.stack.num_domy*geom.mech.amech*sqrt(3)/2,'%10.9e'));
        
    else
        copy = workplane.geom.create('cp_wall_c', 'Copy');
        copy.selection('input').set({'cp1_c' 'cp2_c'});
        copy.set('displx', '0');
        copy.set('disply', num2str(-(geom.stack.num_domy-1)*geom.mech.amech*sqrt(3)/2,'%10.9e'));
    end
    
    array = workplane.geom.create('arr_a', 'Array');
    array.selection('input').set({'uni_a'});
    array.set('fullsize', [1 floor(geom.stack.num_domy/2)+1]);
    array.set('displ', {'0' num2str(-geom.mech.amech*sqrt(3),'%10.9e')});
    
    array = workplane.geom.create('arr_copy_a', 'Array');
    array.selection('input').set({'cp1_a' 'cp2_a'});
    array.set('fullsize', [1 floor((geom.stack.num_domy+1)/2)]);
    array.set('displ', {'0' num2str(-geom.mech.amech*sqrt(3),'%10.9e')});
    
    array = workplane.geom.create('arr_b', 'Array');
    array.selection('input').set({'uni_b'});
    array.set('fullsize', [1 floor((geom.stack.num_domy+1)/2)]);
    array.set('displ', {'0' num2str(-geom.mech.amech*sqrt(3),'%10.9e')});
    
    array = workplane.geom.create('arr_copy_b', 'Array');
    array.selection('input').set({'cp1_b' 'cp2_b'});
    array.set('fullsize', [1 floor(geom.stack.num_domy/2)]);
    array.set('displ', {'0' num2str(-geom.mech.amech*sqrt(3),'%10.9e')});
    
    array = workplane.geom.create('arr_c', 'Array');
    array.selection('input').set({'uni_c'});
    array.set('fullsize', [1 floor((geom.stack.num_domy+1)/2)]);
    array.set('displ', {'0' num2str(-geom.mech.amech*sqrt(3),'%10.9e')});
    
    array = workplane.geom.create('arr_copy_c', 'Array');
    array.selection('input').set({'cp1_c' 'cp2_c'});
    array.set('fullsize', [1 floor(geom.stack.num_domy/2)]);
    array.set('displ', {'0' num2str(-geom.mech.amech*sqrt(3),'%10.9e')});
    
    mir = workplane.geom.create('mir1', 'Mirror');
    mir.set('keep', true);
    mir.selection('input').set({'arr_a' 'arr_b' 'arr_c' 'arr_copy_a' 'arr_copy_b' 'arr_copy_c'});
    mir.set('pos', {'0' num2str(geom.mech.mirror_y,'%10.9e')});
    mir.set('axis', [0 1]);
    
end